RequireScript("engine/namegen.js");RequireScript("engine/quests.js");RequireScript("engine/stat.js");RequireScript("engine/bullets.js");RequireScript("engine/items.js");RequireScript("engine/camera.js");RequireScript("engine/ship.js");RequireScript("engine/player.js");RequireScript("engine/planets.js");RequireScript("engine/asteroids.js");RequireScript("engine/starchart.js");RequireScript("engine/game_worlds.js");RequireScript("engine/particle_engine.js");RequireScript("engine/enemy.js");var Genesis=({player:new Player(),ships:[],bullets:[],planets:[],stars:[],asteroids:[],showChart:false,showMinimap:false,selPlanet:null,highlight_name:"",highlight_status:"",help:true,help_msg:"",useMouse:false,range:10,updatePlanets:function(){var i=this.planets.length;while(i--)Planets[this.planets[i]].update();},createBullet:function(bullet){this.bullets.push(bullet);},generateStars:function(){var i=50;while(i--){var star=new Star(Math.random()*SW,Math.random()*SH);star.speed=Math.ceil(Math.random()*6)/7;this.stars.push(star);}},generateAsteroids:function(world){var i=world.asteroidDensity;while(i--){var asteroid=new Asteroid(-5000+(Math.random()*10000),-5000+(Math.random()*10000));this.asteroids.push(asteroid);}},updateBraces:function(){if(this.selPlanet!=null){this.drawBraces(this.selPlanet.xx,this.selPlanet.yy,this.selPlanet.w,this.selPlanet.h);}
if(this.player.target!=null){this.drawBraces(this.player.target.xx,this.player.target.yy,this.player.target.w,this.player.target.h);}},drawBraces:function(x,y,w,h){Resources.images.ul_brace.blit(x,y);Resources.images.ur_brace.blit(x+w-16,y);Resources.images.dr_brace.blit(x+w-16,y+h-16);Resources.images.dl_brace.blit(x,y+h-16);},nx:0,ny:0,updateGameWorld:function(){this.help_msg="";if(GameWorlds[this.currentWorld].nebula){Resources.images[GameWorlds[this.currentWorld].nebula].blit(Camera.x/10,Camera.y/10);}
Utility.call(this.stars,"update");this.updateHighlight();this.generateShips();if(Cursor.onLeftClick()){Utility.call(this.ships,"checkMouse");}
this.updatePlanets();Utility.call(this.asteroids,"update");Utility.call(this.ships,"update");Utility.call(this.bullets,"update");this.updateBraces();this.player.update();ParticleEngine.updateParticles();this.drawGUI();while(AreKeysLeft()){switch(GetKey()){case KEY_TAB:this.showChart=!this.showChart;break;case KEY_M:this.showMinimap=!this.showMinimap;break;case KEY_Q:var queststate=new QuestState();queststate.show();break;case KEY_MINUS:if(this.range<25)this.range++;break;case KEY_EQUALS:if(this.range>1)this.range--;break;case KEY_ESCAPE:gamemenu.show();break;case KEY_1:this.player.setupShip(Ships[0]);break;case KEY_2:this.player.setupShip(Ships[1]);break;case KEY_3:this.player.setupShip(Ships[2]);break;case KEY_4:this.player.setupShip(Ships[3]);break;case KEY_5:this.player.setupShip(Ships[4]);break;case KEY_6:this.player.setupShip(Ships[5]);break;case KEY_F1:ShowHelp();break;}}},purgeObj:function(){this.selPlanet=null;this.highlight_name="";this.highlight_status="";},updateHighlight:function(){if(this.selPlanet!=null){if(GetDist(this.player.x,this.player.y,this.selPlanet.x,this.selPlanet.y)>800)this.purgeObj();}},drawStatusBar:function(text,x,y,stat,col1,col2){var w=SW/6;var h=20;var delta=stat.value/stat.max*(w-4);GradientRectangle(x-w/2,y,w,h,Colors.darkGray,Colors.darkGray,Colors.black,Colors.black);OutlinedRectangle(x-w/2,y,w,h,Colors.darkGray,1);GradientRectangle(x-w/2+2,y+2,delta,h-4,col1,col1,col2,col2);System.windowFont.drawText(x-w/2+4,y+2,text);},drawGUI:function(){Resources.images.testoverlay.blit(0,0);this.drawStatusBar("Armor",SW/2,SH-80,Genesis.player.hp,Colors.green,Colors.darkGreen);this.drawStatusBar("Fuel",SW/2,SH-56,Genesis.player.jumps,Colors.purple,Colors.darkPurple);System.textFont.drawText(4,4,"Cred: "+this.player.credits);System.textFont.drawText(4,24,"Capacity: "+this.player.cap.value+"/"+this.player.cap.max);System.textFont.drawText(4,44,"Escorts: "+this.player.escort.value+"/"+this.player.escort.max);System.textFont.drawText(SW-System.textFont.getStringWidth(this.currentWorld+" System")-4,4,this.currentWorld+" System");if(this.showChart)StarChart.drawChart(0,SH-240);else if(StarChart.selectedSystem!=null)System.textFont.drawText(4,SH-18,"Targeted System: "+StarChart.selectedSystem.name);if(this.showMinimap)this.drawMinimap();if(this.selPlanet!=null){this.highlight_name=this.selPlanet.name;this.highlight_status="-"+this.selPlanet.status+"-";var x=this.selPlanet.x;var y=this.selPlanet.y;if(this.player.cx>x&&this.player.cy>y&&this.player.cx<x+this.selPlanet.w&&this.player.cy<y+this.selPlanet.h){if(this.selPlanet.canLand&&this.player.speed<1.5)Genesis.help_msg="Press L to Land on this Planet.";if(IsKeyPressed(KEY_L)){this.player.updateQuestDays();this.save("Autosave");var l_state=new LandState(this.selPlanet);l_state.show();}}}
System.textFont.drawText(SW/2-System.textFont.getStringWidth(this.highlight_name)/2,4,this.highlight_name);System.textFont.drawText(SW/2-System.textFont.getStringWidth(this.highlight_status)/2,20,this.highlight_status);System.textFont.drawText(SW-System.textFont.getStringWidth(this.help_msg)-4,SH-20,this.help_msg);},setName:function(name,status){if(!status)status="";if(this.selPlanet==null){this.highlight_name=name;this.highlight_status=status;}},loadGameWorld:function(world){world=GameWorlds[world];this.ids=0;this.currentWorld=world.name;this.purgeGameWorld();this.generateStars();this.generateAsteroids(world);this.planets=world.planets;for(var i=0;i<this.planets.length;++i){Planets[this.planets[i]].generateQuests();}
Genesis.player.addBountyShips();this.selPlanetect=null;StarChart.ox=world.origin.x;StarChart.oy=world.origin.y;this.addRandomShip();},ids:0,addRandomShip:function(){var ship=CreateRandomShip();if(Utility.random(9)>=5)
ship.x=-3000+Utility.random(1000);else ship.x=2000+Utility.random(1000);if(Utility.random(9)>=5)
ship.y=-3000+Utility.random(1000);else ship.y=2000+Utility.random(1000);ship.id=this.ids;this.ids++;this.ships.push(ship);},t_ship:0,t_ship_msecs:2000,generateShips:function(){if(this.t_ship==0)this.t_ship=GetTime();if(this.t_ship+this.t_ship_msecs<GetTime()){if(this.ships.length<GameWorlds[this.currentWorld].shipcap){this.addRandomShip();this.t_ship_msecs=2000+Utility.random(1000);}
this.t_ship=0;}},purgeGameWorld:function(){this.purgeObj();this.stars=[];this.ships=[];this.planets=[];this.bullets=[];this.asteroids=[];},purgePlayer:function(){this.player=new Player();},drawMinimap:function(){var mx=SW-321,my=SH-241,i=0;SetClippingRectangle(mx,my,320,240);Rectangle(mx,my,320,240,Colors.black);System.windowFont.drawText(mx+2,my+2,"Zoom: x"+this.range+"/1");i=this.ships.length;while(i--){var ship=this.ships[i];OutlinedCircle(mx+160+(ship.cx-this.player.x)/this.range,my+120+(ship.cy-this.player.y)/this.range,ship.w/(this.range*2),Colors.gray);}
i=this.planets.length;while(i--){var planet=Planets[this.planets[i]];OutlinedCircle(mx+160+(planet.x+planet.w/2-this.player.x)/this.range,my+120+(planet.y+planet.h/2-this.player.y)/this.range,planet.w/(this.range*2),Colors.gray);}
Resources.images.playerblip.rotateBlitMask(mx+160,my+120,this.player.a.radians,Colors.yellow);OutlinedCircle(mx+168,my+128,this.player.w/(this.range*2),Colors.yellow);SetClippingRectangle(0,0,SW,SH);OutlinedRectangle(mx,my,321,241,Colors.gray);},save:function(filename){var File=OpenFile(filename+".sav");File.write("Player",JSON.stringify(this.player));File.write("World",this.currentWorld);File.write("CamX",Camera.x);File.write("CamY",Camera.y);File.flush();File.close();},load:function(filename){this.purgeGameWorld();this.purgePlayer();var File=OpenFile(filename+".sav");this.player.load(File);this.loadGameWorld(File.read("World","Sol"));File.close();}})
function Star(x,y)
{this.image=Resources.images.star;this.x=x;this.y=y;this.color=CreateColor(155+Math.floor(Math.random()*100),200+Math.floor(Math.random()*55),155+Math.floor(Math.random()*100));this.speed=0;}
Star.prototype.update=function()
{this.image.blitMask(this.x,this.y,this.color);this.x-=Genesis.player.vx*this.speed;this.y-=Genesis.player.vy*this.speed;if(this.y>SH)this.y=0;if(this.y<0)this.y=SH;if(this.x>SW)this.x=0;if(this.x<0)this.x=SW;}